-- -- [[ Turret creator ]]--

local function TurretMount (turret_name,  tbl , turret_)
	tbl.category = CAT_GUN_MOUNT
	tbl.name = turret_name   
	
	tbl.supply = {
		mixes = {{1,1,4}},
		count = 800,
	}
	if tbl.mixes then
		tbl.supply.mixes = tbl.mixes
		tbl.mixes = nil
	end
	if tbl.count then
		tbl.supply.count = tbl.count
		tbl.count = nil
	end
	tbl.gun = {
		max_burst_length = 30,
		rates = {1150}, -- unsynchronized mount
		recoil_coeff =  0.7*1.3,
		barrel_circular_error = 0.0002,
		barrels_count = 1,
		trigger = {name ="GunTrigger"}
	}
	tbl.effective_fire_distance = 250;
	
	tbl.ejector_pos = tbl.ejector_pos or {0.0, 0.00, -0.5}
	tbl.ejector_dir = tbl.ejector_dir or {0, 0, -1}
	--tbl.effect_arg_number = tbl.effect_arg_number or 436
	tbl.supply_position = tbl.supply_position or {0, 0.3, -0.3}
	tbl.aft_gun_mount = false
	tbl.muzzle_pos = {0, 0, 0} -- all position from connector
	tbl.azimuth_initial = tbl.azimuth_initial or 0
	tbl.elevation_initial = tbl.elevation_initial or 0
	tbl.turret = turret_
	tbl.effects = {
        {name = "FireEffect", arg = 432, attenuation = 2.0, light_pos = {0.5, 0.5, 0.0} , light_time = 0.1},
        {name = "SmokeEffect"},
    }

	return declare_weapon(tbl)  --declare_gun_mount(tbl.name,tbl)
end


dofile(current_mod_path..'/Lancaster_damage.lua')


Lancaster_B1 =  {
        
	Name 				=  'Lancaster',
	DisplayName			= _('Lancaster'),
	
	HumanCockpit 		= false,
	HumanCockpitPath    = current_mod_path.."/Cockpit/",
	
	Picture				= 'loadout.png', -- loadout picture
	Rate 				= 40, -- RewardPoint in Multiplayer
	Shape 				= "Lancaster",	
	XRayShape           = "Lancaster_x_ray",
	propellorShapeType	= '3ARG_PROC_BLUR',
	propellorShapeName  = 'Lanc_Prop.fbx',
	debrisGeneration     = true,
	Countries 			= {"USA","Canada","UK"},

	shape_table_data 	= 
	{
		{
			file  	 = 'Lancaster';
			life  	 = 120; -- lifebar
			vis   	 = 9; -- visibility gain.
			desrt    = ''; -- Name of destroyed object file name
			fire  	 = { 600, 8}; -- Fire on the ground after destoyed: 300sec 2m
			username = 'Lancaster';
			index    =  WSTYPE_PLACEHOLDER;
			classname   = "lLandPlane";
			positioning = "BYNORMAL";
			drawonmap = true;

		},
	--	{
		--TODO: Destroyed model
	--		name  = "Lancaster_destr";  
	--		file  = "Lancaster-destr";
	--		fire  = { 240, 2};
	--	},
	},
	
	mapclasskey 		= "P0091000026",
	attribute = { 1, 1, 4, "Redacted", "Strategic bombers", "Bombers", "All", "NonAndLightArmoredUnits", "NonArmoredUnits", "Air", "Planes", "Battle airplanes" },
	--Categories 			= {"{78EFB7A2-FD52-4b57-A6A6-3BF0E1D6555F}", "Interceptor",},	


	
	-------------------- Aircraft attributes ------------------------------------------------------------------------------
	EmptyWeight									=   16738,
	M_empty										=	16738, -- kg  --should be 16738
	M_fuel_max									=	7220,  -- kg --2154 imperial gallons
	M_max										=	30844, -- kg 
	M_nominal									=	24948, -- kg  --should be 24948
	AmmoWeight 									=	400.4, --kg (14,000 .303 cartridges x 28.6g each)
	height										=	6.25,--m
	length										=	21.13,--m

	wing_area									=	120.5,--m^2 
	wing_span									=	31.09,--m -- 
	wing_tip_pos 								= 	{-1.98, 1.25, 15.3},	 -- {forward/back,up/down,left/right}
	wing_type           						=   0,    -- FIXED_WING = 0, VARIABLE_GEOMETRY = 1, FOLDED_WING = 2, VARIABLE_GEOMETRY_FOLDED = 3
	wing_ad_sections							=   {0, 0, 0, 1, 1, 2, 2},

	IR_emission_coeff							=	0.1, -- 1.0 is IR emission of Su-27
	IR_emission_coeff_ab						=	0.1,
	RCS											=	7, --m^2
	defFuelRatio								=	0.8, -- default fuel amount in fraction of full
	bigParkingRamp								=	false,
	brakeshute_name								=	0,
	has_afteburner								=	false, 
	has_differential_stabilizer					=	false,
	has_speedbrake								=	false,

	flaps_transmission 							= 	"Hydraulic",
    undercarriage_transmission 					= 	"Hydraulic",
	doors_transmission 							= 	"Hydraulic",
    undercarriage_movement 						= 10,
    bomb_bay_movement 							= 12,
	doors_movement 								= 5,

	tanker_type									=	0, -- 1 boom, 2 probe
	air_refuel_receptacle_pos 					=	{0,0,0},

------------------------ Gear ---------------------------------------------
--- tail wheel --- 
	nose_gear_pos 							 = {-10, -1, 0}, --{forward/back,up/down,left/right} coordinate of tailwheel contact point with runway,  used for initial aircraft placement
	nose_gear_amortizer_direct_stroke        =  0,	-- down from nose_gear_pos
	nose_gear_amortizer_reversal_stroke      =  -0.1,	-- max strut compression up from nose_gear_pos
	nose_gear_amortizer_normal_weight_stroke =  -0.05, 	--0.05,
	nose_gear_wheel_diameter				 =	0.5, 	
	tand_gear_max							 =	0.577, -- tailwheel is not steerable, use engine and brakes instead --1.63, -- nosewheel steering angle.  (tan(25)=0.1333 +/-25 degrees) (UPDATED) Steering is about 70 degrees now so it turns more realistically with the free tailwheel

-- main gear	
	
	main_gear_pos 							 = {2.68, -2.9, 4}, -- coordinate of main wheel contact point with runway, used for initial aircraft placement
	main_gear_amortizer_direct_stroke	     =  0,	--  down from main_gear_pos 
	main_gear_amortizer_reversal_stroke      =  -0.26,---0.1, --   max strut compression up from main_gear_pos 
	main_gear_amortizer_normal_weight_stroke =  -0.1,---0.1,
	main_gear_wheel_diameter				 =	1.5,


------------------------------ AI defs	-----------------------------------
--- performance sources: https://www.wwiiaircraftperformance.org/Lancaster/Lancaster.html
	AOA_take_off								=	0.08,--0.12,
	CAS_min										=	56,
	Mach_max									=	0.5,
	H_max										=	7315,	-- max altitude in meters
	Ny_max										=	4,		-- max G for AI
	Ny_max_e									=	8,
	Ny_min										=	-2,		-- min G for AI
	bank_angle_max								=	45,
	V_land										=	34,  	-- m/s, landing speed
	V_max_h										=	109.07, --m/s, max level speed at ceiling
	V_max_sea_level								=	100.6,  --m/s, 225 mph, max level speed at sea level
	V_opt										=	89.4, 	--m/s -- cruise speed
	V_take_off									=	45,  	--m/s, 100 mph
	Vy_max										=	4.06,	-- climb speed
	range										=	1200,
	flaps_maneuver								=	0.2,
	MaxHeight 									=   7315,   -- max altitude in meters
	MaxSpeed 									=   160,
	Waypoint_Custom_Panel 						=   true,

	
	Sensors = { -- defines what AI is capable of
	},

	radar_can_see_ground						=	false,
	detection_range_max							=	0,--km range of radar
	aim_error_level_bombing 					=   0.2,
	aim_error_dive_bombing	 					=   100.0,
    aim_error_ground_attack						=   100.0,	
    date_of_introduction						=   1942,
	thrust_sum_ab								=	8224*4, --?? kg doesn't seem to affect flight model
	thrust_sum_max								=	8224*4,
	average_fuel_consumption					=	0.302,--0.86, -- kg/s TSFC? doesn't seem to affect fuel consumption  	

	
	engines_count	=	4,
	engines_nozzles ={
		[1] =
		{
			pos =     {1.0,  0.2, -8.3}, -- nozzle coords forward/back,up/down,left/right
            elevation    =    0.0, -- AFB cone elevation
            diameter    =    0.0, -- AFB cone diameter
            exhaust_length_ab    =    -3, -- lenght in m
            exhaust_length_ab_K    =   0.607, -- AB animation
            smokiness_level     =     0.05,
			engine_number = 1
		},
		[2] =
		{
			pos =     {1.0,  0.2, -7.0}, -- nozzle coords forward/back,up/down,left/right
            elevation    =    0.0, -- AFB cone elevation
            diameter    =    0.0, -- AFB cone diameter
            exhaust_length_ab    =    -3, -- lenght in m
            exhaust_length_ab_K    =   0.607, -- AB animation
            smokiness_level     =     0.05,
			engine_number = 1


		},
		[3] =
		{
			pos =     {1.0,  0.1, -4.2}, -- nozzle coords forward/back,up/down,left/right
            elevation    =    0.0, -- AFB cone elevation
            diameter    =    0.0, -- AFB cone diameter
            exhaust_length_ab    =    3, -- lenght in m
            exhaust_length_ab_K    =    0.607, -- AB animation
            smokiness_level     =     0.05,
			engine_number = 2

		},
		[4] =
		{
			pos =     {1.0,  0.1, -3.0}, -- nozzle coords forward/back,up/down,left/right
            elevation    =    0.0, -- AFB cone elevation
            diameter    =    0.0, -- AFB cone diameter
            exhaust_length_ab    =    3, -- lenght in m
            exhaust_length_ab_K    =    0.607, -- AB animation
            smokiness_level     =     0.05,
			engine_number = 2

		},

		[5] =
		{
			pos =     {1.0,  0.1, 3.0}, -- nozzle coords forward/back,up/down,left/right
            elevation    =    0.0, -- AFB cone elevation
            diameter    =    0.0, -- AFB cone diameter
            exhaust_length_ab    =    -3, -- lenght in m
            exhaust_length_ab_K    =   0.607, -- AB animation
            smokiness_level     =     0.05,
			engine_number = 3
		},
		[6] =
		{
			pos =     {1.0,  0.1, 4.2}, -- nozzle coords forward/back,up/down,left/right
            elevation    =    0.0, -- AFB cone elevation
            diameter    =    0.0, -- AFB cone diameter
            exhaust_length_ab    =    -3, -- lenght in m
            exhaust_length_ab_K    =   0.607, -- AB animation
            smokiness_level     =     0.05,
			engine_number = 3


		},
		[7] =
		{
			pos =     {1.0,  0.2, 7.0}, -- nozzle coords forward/back,up/down,left/right
            elevation    =    0.0, -- AFB cone elevation
            diameter    =    0.0, -- AFB cone diameter
            exhaust_length_ab    =    3, -- lenght in m
            exhaust_length_ab_K    =    0.607, -- AB animation
            smokiness_level     =     0.05,
			engine_number = 4

		},
		[8] =
		{
			pos =     {1.0,  0.2, 8.4}, -- nozzle coords forward/back,up/down,left/right
            elevation    =    0.0, -- AFB cone elevation
            diameter    =    0.0, -- AFB cone diameter
            exhaust_length_ab    =    3, -- lenght in m
            exhaust_length_ab_K    =    0.607, -- AB animation
            smokiness_level     =     0.05,
			engine_number = 4

		},
	},

	sounderName =  "Aircraft/Planes/Lancaster",
	InheritCommonCallnames = true, --e


	crew_size	 = 7,
	crew_members = {
		[1] = -- pilot 
        {
			pilot_name = "pilot_raf",
            ejection_seat_name  = 0,
			ejection_added_speed = {-0.5, -1.0, -2.0},
            drop_canopy_name    = "bombardier_hatch", 
            pos 				= {0.0, 0.0, 0.0}, -- used for ejection location for the seat model to appear. See other view settings for cockpit view
            canopy_pos 			= {0.0, 0.0, 0.0}, -- pilot only
			ejection_order      = 1,
			can_be_playable 	= true,
			pilot_body_arg 		= 50, -- arg plays when crewman is killed, also stores crewman health status. Can be skipped for cremen without death effect. Make sure you have different death args for all killable crew.
			role 				= "pilot",
			role_display_name   = _("Pilot"),
			--ejection_through_canopy = true,		
			bailout_arg 		= -1,
			drop_parachute_name	 = "pilot_raf_parachute",
			canopy_arg = 200,
			
        }, 
		[2] =
        {
			pilot_name = "pilot_raf",
            ejection_seat_name  = 0,
			ejection_added_speed = {-0.5, -1.0, -2.0},
            drop_canopy_name    = "bombardier_hatch", 
            pos 				= {5.9, -0.52, 0}, -- used for ejection location for the seat model to appear. See other view settings for cockpit view  forward/back,up/down,left/right
            canopy_pos 			= {5.9, -0.52, 0},
			ejection_order      = 2,
			can_be_playable 	= true,
			pilot_body_arg 		= 460,
			role 				= "flight_officer",
			role_display_name   = _("Bombardier"),
			--ejection_through_canopy = true,		
			bailout_arg 		= -1,
			drop_parachute_name	 = "pilot_raf_parachute",
			canopy_arg = 201,
        }, 

		[3] =
        {
			pilot_name = "pilot_raf",
            ejection_seat_name  = 0,
			ejection_added_speed = {-0.5, -1.0, -2.0},
            drop_canopy_name    = "", 
            pos 				= {-4, -0.52, 0}, -- used for ejection location for the seat model to appear. See other view settings for cockpit view  forward/back,up/down,left/right
            canopy_pos 			= {-4, -0.52, 0},
			ejection_order      = 3,
			can_be_playable 	= true,
			--pilot_body_arg 		= 50,
			role 				= "flight_officer",
			role_display_name   = _("Engineer"),
			--ejection_through_canopy = true,		
			bailout_arg 		= -1,
			drop_parachute_name	 = "pilot_raf_parachute",
			
        }, 

		[4] =
        {
			pilot_name = "pilot_raf",
            ejection_seat_name  = 0,
			ejection_added_speed = {-0.5, -1.0, -2.0},
            drop_canopy_name    = "", 
            pos 				= {-4, -0.52, 0}, -- used for ejection location for the seat model to appear. See other view settings for cockpit view  forward/back,up/down,left/right
            canopy_pos 			= {-4, -0.52, 0},
			ejection_order      = 4,
			can_be_playable 	= true,
			--pilot_body_arg 		= 50,
			role 				= "flight_officer",
			role_display_name   = _("Navigator"),
			--ejection_through_canopy = true,		
			bailout_arg 		= -1,
			drop_parachute_name	 = "pilot_raf_parachute",
			
        }, 

		[5] =
        {
			pilot_name = "pilot_raf",
            ejection_seat_name  = 0,
			ejection_added_speed = {-0.5, -1.0, -2.0},
            drop_canopy_name    = "", 
            pos 				= {-4, -0.52, 0}, -- used for ejection location for the seat model to appear. See other view settings for cockpit view  forward/back,up/down,left/right
            canopy_pos 			= {-4, -0.52, 0},
			ejection_order      = 5,
			can_be_playable 	= true,
			--pilot_body_arg 		= 36,
			role 				= "flight_officer",
			role_display_name   = _("Wireless Operator"),
			--ejection_through_canopy = true,		
			bailout_arg 		= -1,
			drop_parachute_name	 = "pilot_raf_parachute",
			
        }, 

		[6] =
        {
			pilot_name = "pilot_raf",
            ejection_seat_name  = 0,
			ejection_added_speed = {-0.5, -1.0, -2.0},
            drop_canopy_name    = "", 
            pos 				= {-4, -0.52, 0}, -- used for ejection location for the seat model to appear. See other view settings for cockpit view  forward/back,up/down,left/right
            canopy_pos 			= {-4, -0.52, 0},
			ejection_order      = 6,
			can_be_playable 	= true,
			pilot_body_arg 		= 463,
			role 				= "gunner",
			role_display_name   = _("Mid Upper Gunner"),
			--ejection_through_canopy = true,		
			bailout_arg 		= -1,
			drop_parachute_name	 = "pilot_raf_parachute",
			
        }, 

		[7] =
        {
			pilot_name = "pilot_raf",
            ejection_seat_name  = 0,
			ejection_added_speed = {-0.5, -1.0, -2.0},
            drop_canopy_name    = "", 
            pos 				= {-8, -0.52, 0}, -- used for ejection location for the seat model to appear. See other view settings for cockpit view  forward/back,up/down,left/right
            canopy_pos 			= {-8, -0.52, 0}, 
			ejection_order      = 7,
			can_be_playable 	= true,
			pilot_body_arg 		= 464,
			role 				= "gunner",
			role_display_name   = _("Tail Gunner"),
			--ejection_through_canopy = true,		
			bailout_arg 		= -1,
			drop_parachute_name	 = "pilot_raf_parachute",
			
        }, 
	}, -- end of crew

	crew_stations = "HumanOrchestra",

	
	fires_pos = 
		{
			[1] = 	{-2.117,	-0.9,	0}, 		-- Fuselage
			[2] = 	{0.4,	0.05,	2.14},  		-- WING_R_IN
			[3] = 	{0.4,	0.05,	-2.14}, 		-- WING_L_IN
			[4] = 	{-0.82,	0.265,	2.774}, 		-- Wing center Right? 
			[5] = 	{-0.82,	0.265,	-2.774}, 		-- Wing center Right?
			[6] = 	{-0.82,	0.255,	4.274}, 		-- Wing center Left? 
			[7] = 	{-0.82,	0.255,	-4.274}, 		-- Wing outer Left?
			[8] =   {3.0,  0.2, 7.5}, 				--engine 1 contrail
			[9] = 	{3.5,  0.1, 3.7}, 				--engine 2 contrail
			[10] = 	{3.5,  0.1, -3.7}, 				--engine 3 contrail
			[11] = 	{3.0,  0.2, -7.5}, 				--engine 4 contrail
		}, -- end of fires_pos

	
	Damage = verbose_to_dmg_properties(Lanc_damage),
	DamageParts = 
	{  
		 [1] = 	"Lancaster_oblomok_wing_outer_R", -- wing R
         [2] = 	"Lancaster_oblomok_wing_outer_L", -- wing L
		 [3] = 	"Lancaster_oblomok_nose",
		 [4] = 	"Lancaster_oblomok_tail",
		-- [5] = 	"Lancaster_oblomok_elevator_R",
		-- [6] = 	"Lancaster_oblomok_elevator_L",
		-- [7] = 	"Lancaster_oblomok_stabilizer_L",
		-- [8] = 	"Lancaster_oblomok_stabilizer_L",
		-- [9] = 	"Lancaster_oblomok_rudder_L",
		-- [10] = 	"Lancaster_oblomok_rudder_L"
	},

	--sensors

	CanopyGeometry 			 = makeAirplaneCanopyGeometry(LOOK_GOOD, LOOK_GOOD, LOOK_GOOD),

	HumanRadio = {
		frequency = 127.5,  -- Radio Freq
		editable = true,
		minFrequency = 100.000,
		maxFrequency = 156.000,
		rangeFrequency = {
            {min = 100.000, max = 156.000},
            {min = 5.500, max = 10.000},
            {min = 3.000, max = 5.500},
            {min = 0.200, max = 0.500},
        },
		modulation = MODULATION_AM
	},
	panelRadio = {
        [1] = {
            ID = "SCR522",
            name = _("TR.1143"),
            displayUnits = "MHz",
            range = {min = 38.000, max = 156.000},
            channels = {
                [1] = {name = _("Channel A"),             default = 105.000, modulation = _("AM"), connect = true},
                [2] = {name = _("Channel B"),             default = 124.000, modulation = _("AM")},
                [3] = {name = _("Channel C"),             default = 131.000, modulation = _("AM")},
                [4] = {name = _("Channel D"),             default = 139.000, modulation = _("AM")},
                [5] = {name = _("A.1271 Base Frequency"), default = 108.900, modulation = _("AM")},
            }
        },
        [2] = {
            ID = "T1154R1155R1",
            name = _("T.1154N Range 1"),
            displayUnits = "MHz",
            range = {
                {min = 5.500, max = 10.000},
            },
            channels = {
                [1] = {name = _("Preset A"), default = 9.255, modulation = _("AM")},
                [2] = {name = _("Preset B"), default = 8.000, modulation = _("AM")},
                [3] = {name = _("Preset C"), default = 7.710, modulation = _("AM")},
                [4] = {name = _("Preset D"), default = 6.872, modulation = _("AM")},
                [5] = {name = _("Preset E"), default = 5.955, modulation = _("AM")},
                [6] = {name = _("Preset F"), default = 5.850, modulation = _("AM")},
                [7] = {name = _("Preset G"), default = 5.750, modulation = _("AM")},
                [8] = {name = _("Preset H"), default = 5.650, modulation = _("AM")},
            }
        },
        [3] = {
            ID = "T1154R1155R2",
            name = _("T.1154N Range 2"),
            displayUnits = "MHz",
            range = {
                {min = 3.000, max = 5.500},
            },
            channels = {
                [1] = {name = _("Preset J"), default = 5.250, modulation = _("AM")},
                [2] = {name = _("Preset K"), default = 5.000, modulation = _("AM")},
                [3] = {name = _("Preset L"), default = 4.750, modulation = _("AM")},
                [4] = {name = _("Preset M"), default = 4.500, modulation = _("AM")},
                [5] = {name = _("Preset N"), default = 4.250, modulation = _("AM")},
                [6] = {name = _("Preset P"), default = 3.250, modulation = _("AM")},
                [7] = {name = _("Preset Q"), default = 3.012, modulation = _("AM")},
                [8] = {name = _("Preset R"), default = 3.011, modulation = _("AM")},
            }
        },
        [4] = {
            ID = "T1154R1155R3",
            name = _("T.1154N Range 3"),
            displayUnits = "kHz",
            range = {
                {min = 200.000, max = 500.000},
            },
            channels = {
                [1] = {name = _("Preset S"), default = 0.444000, modulation = _("AM")},
                [2] = {name = _("Preset T"), default = 0.421000, modulation = _("AM")},
                [3] = {name = _("Preset U"), default = 0.303000, modulation = _("AM")},
                [4] = {name = _("Preset V"), default = 0.300000, modulation = _("AM")},
                [5] = {name = _("Preset W"), default = 0.270000, modulation = _("AM")},
                [6] = {name = _("Preset X"), default = 0.260000, modulation = _("AM")},
                [7] = {name = _("Preset Y"), default = 0.250000, modulation = _("AM")},
                [8] = {name = _("Preset Z"), default = 0.240000, modulation = _("AM")},
            }
        },
    },

	 Guns 	= {  
	
	-- Nose MG top left
		Browning303({
            muzzle_pos_connector = "GUN_1",
            --effect_arg_number = 350,
            count = 1000,
			mixes = {{3,3,3,2,4}},
            azimuth_initial = 0.0,
            elevation_initial = 0.0,
            supply_position = {-0.385, -0.179, -4.205},
            ejector_pos_connector = nil,
            ejector_dir           = {0, 1, 0},
            drop_cartridge        = 0,--204,
        }),

	-- Nose MG top right
        Browning303({
            muzzle_pos_connector = "GUN_2",
            --effect_arg_number = 433,
            count = 1000,
			mixes = {{3,3,3,2,4}},
            azimuth_initial = 0.0,
            elevation_initial = 0.0,
            supply_position = {-0.385, -0.179, -4.205},
            ejector_pos_connector = nil,
            ejector_dir           = {0, 1, 0},
            drop_cartridge        = 0,
        }),

	-- Midupper MG  right
		Browning303({
			muzzle_pos_connector = "GUN_7",
			--effect_arg_number = 434,
			count = 1000,
			mixes = {
				{3,3,3,3,2},
			},
			azimuth_initial = 180.0,
			elevation_initial = 0.0,
			supply_position = {-0.385, -0.179, -4.205},
            ejector_pos_connector = nil,
			ejector_dir           = {0, -0.33, -0.33},
			drop_cartridge        = 0,
		}),

		-- Midupper MG left
        Browning303({
            muzzle_pos_connector = "GUN_8",
         --  effect_arg_number = 434,
            count = 1000,
			mixes = {
				{3,3,3,3,2},
			},
            azimuth_initial = 180.0,
            elevation_initial = 0.0,
            supply_position = {-0.385, -0.179, -4.205},
			ejector_pos_connector = nil,
            ejector_dir           = {0, -0.33, -0.33},
            drop_cartridge        = 0,
        }),

		-- Tail MG rear left top
        Browning303({
            muzzle_pos_connector = "GUN_5",
           -- effect_arg_number = 435,
            count = 2500,
			mixes = {
				{4},
			},
            azimuth_initial = 180.0,
            elevation_initial = 0.0,
            supply_position = {-0.385, -0.179, -4.205},
            ejector_pos_connector = {0, -0.5 ,0},
            ejector_dir           = {0, -0.33, -0.33},
            drop_cartridge        = 205,
        }),

		-- Tail MG rear left bottom
        Browning303({
            muzzle_pos_connector = "GUN_6",
           -- effect_arg_number = 436,
            count = 2500,
			mixes = {
				{3,3,3,3,2},
			},
            azimuth_initial = 180.0,
            elevation_initial = 0.0,
            supply_position = {-12.0, -0.179, -4.205},
            ejector_pos_connector = {0, -0.5, 0},
            ejector_dir           = {0, -0.33, -0.33},
            drop_cartridge        = 205,
         }),
		
		-- Tail MG left
        Browning303({
            muzzle_pos_connector = "GUN_4",
          --  effect_arg_number = 1004,
			count = 2500,
			mixes = {
				{4},
			},
            azimuth_initial = 180.0,
            elevation_initial = 0.0,
            supply_position = {-12.0, -0.179, 4.205},
            ejector_pos_connector = nil,
            ejector_dir           = {0, 1, 0},
            drop_cartridge        = 205,

        }),

		-- Tail MG right
		Browning303({
            muzzle_pos_connector = "GUN_3",
			--effect_arg_number = 1004,
			count = 2500,
			mixes = {
				{4},
			},
            azimuth_initial = 180.0,
            elevation_initial = 0.0,
            supply_position = {-12.0, -0.179, 4.205},
            ejector_pos_connector = {0, 0,-0.5},
            ejector_dir           = {0, 5, 0},
            drop_cartridge        = 205,
        }),
		
	-- MID UPPER TURRET FN.50
		TurretMount ("LANC_MID_UPPER_R", --0 
						{
							gun = {
								supply = {
									shells = turret_ammo,
									mixes = {
										{3,3,3,2,4},
									},
									count = 1000,
								},
								max_burst_length = 300,
								rates = {1150}, -- unsynchronized mount
								recoil_coeff =  0.7*1.3,
								barrel_circular_error = 0.0002,
								barrels_count = 1,
								trigger = {name ="GunTrigger"},
								ejector_pos = nil,
								ejector_dir = {-1.0, 0.0, 0.0},
							},
							--category = 8,
							muzzle_pos_connector = "GUN_7",
							--effect_arg_number = 1004,
							azimuth_initial = 180.0,
							elevation_initial = 0.0,
							aft_gun_mount = false,
							-- effects = {
							-- 	{name = "FireEffect", arg = 432, attenuation = 2.0, light_pos = {0.5, 0.5, 0.0} , light_time = 0.1},
							-- 	{name = "SmokeEffect"},
							-- }

						} , 
						{	
							name = "Top_turret",
							H_Arg = 1005,				-- horizontal rotation argument
							V_Arg = 1006,				-- vertical rotation argument
							H_Min = -180.0,				-- minimum horizontal gun deflection (degrees)
							H_Max =  180.0,				-- maximum horizontal gun deflection (degrees)
							V_Min =  -15.0, 			-- minimum vertical gun deflection (degrees)
							V_Max =  60.0,				-- maximum vertical gun deflection (degrees)
							H_Vel =  90.0,				-- horizontal gun rotation speed
							V_Vel =  70.0,
							SecondGun = 1,
							crewMemberInCommandIdx	= 6, -- crew member controlling this turret 
						}
					),



		TurretMount ("LANC_MID_UPPER_L", 				--1
						{
							gun = {
								supply = {
									shells = turret_ammo,
									mixes = {
										{3,3,3,2,4},
									},
									count = 1000,
								},
								max_burst_length = 300,
								rates = {1150}, -- unsynchronized mount
								recoil_coeff =  0.7*1.3,
								barrel_circular_error = 0.0002,
								barrels_count = 1,
								trigger = {name ="GunTrigger"},
								ejector_pos = nil,
								ejector_dir = {-1.0, 0.0, 0.0},
							},
							--category = 8,
							muzzle_pos_connector = "GUN_8",
							--effect_arg_number = 1004,
							azimuth_initial = 180.0,
							elevation_initial = 0.0,
							aft_gun_mount = false,
						} , 
						{	
							name = "Top_turret",							
							SlaveGun = true,
						}
					),



		-- REAR TURRET FN.20
		-----------------------------------
		-- right side of the turret (R1 and R2 are the guns doing the aiming and rotating the turret for AI)
		-- left side are locked and can't move independently ( max and min h and v are all 0), but still shoot
		-- when aligned on target by the right side's action.  
		-- This gets around DCS's apparent limitation of 2 guns per turret
		-----------------------------------
		TurretMount ("LANC_AFT_R1", --2 
					{
						gun = {
							supply = {
								shells = turret_ammo,

								mixes = {
									{3},
								},
								count = 2500,
							},
							max_burst_length = 300,
							rates = {1150}, -- unsynchronized mount
							recoil_coeff =  0.7*1.3,
							barrel_circular_error = 0.0002,
							trigger = {name ="GunTrigger"},
							ejector_pos = {0.0, 0.0, -0.5},
							ejector_dir = {-1.0, 0.0, 0.0},
						},
						category = 8,
						muzzle_pos_connector = "GUN_3",
						effect_arg_number = 1004,
						azimuth_initial   = 180.0,
						elevation_initial = 0.0,
						aft_gun_mount     = false,
						-- effects = {
						-- 	{name = "FireEffect", arg = 432, attenuation = 2.0, light_pos = {0.5, 0.5, 0.0} , light_time = 0.1},
						-- 	{name = "SmokeEffect"},
						-- }

					} , 
					{	
						name = "Aft_turret",
						H_Arg = 1021,				-- horizontal rotation argument
						V_Arg = 1022,				-- vertical rotation argument
						H_Min = -94.0,				-- minimum horizontal gun deflection (degrees)
						H_Max =  94.0,				-- maximum horizontal gun deflection (degrees)
						V_Min =  -45.0, 			-- minimum vertical gun deflection (degrees)
						V_Max =  60.0,				-- maximum vertical gun deflection (degrees)
						H_Vel =  90.0,				-- horizontal gun rotation speed
						V_Vel =  70.0,
						SecondGun = 3,
						crewMemberInCommandIdx	= 7, -- crew member controlling this turret 
					}
				),


		TurretMount ("LANC_AFT_R2", 				--3
					{						
						gun = {
							supply = {
								shells = turret_ammo,
								mixes = {
									{3,3,3,3,2},
								},
								count = 2500,
							},
							max_burst_length = 300,
							rates = {1150}, -- unsynchronized mount
							recoil_coeff =  0.7*1.3,
							barrel_circular_error = 0.0002,
							trigger = {name ="GunTrigger"},
							ejector_pos = {0.0, 0.0, -0.5},
							ejector_dir = {-1.0, 0.0, 0.0},
						},
						muzzle_pos_connector = "GUN_4",
						--effect_arg_number = 1004,
						azimuth_initial = 180.0,
						elevation_initial = 0.0,
						aft_gun_mount = false,
					} , 
					{	
						name = "Aft_turret",							
						SlaveGun = true,
					}
		 		),	
		
		TurretMount ("LANC_AFT_L1", 				--4
					{
						gun = {
							supply = {
								shells = turret_ammo,
								mixes = {
									{4},
								},
								count = 2500,
							},
							max_burst_length = 300,
							rates = {1150}, -- unsynchronized mount
							recoil_coeff =  0.7*1.3,
							barrel_circular_error = 0.0002,
							barrels_count = 1,
							trigger = {name ="GunTrigger"},
							ejector_pos = {0.0, 0.0, -0.5},
							ejector_dir = {-1.0, 0.0, 0.0},
						},
						muzzle_pos_connector = "GUN_5",
						--effect_arg_number = 1004,
						count = 2500,
						azimuth_initial = 180.0,
						elevation_initial = 0.0,
						aft_gun_mount		  = false,
					} , 
					{	
						H_Arg = 0,				-- horizontal rotation argument
						V_Arg = 0,				-- vertical rotation argument
						H_Min = 0.0,				-- minimum horizontal gun deflection (degrees)
						H_Max = 0.0,				-- maximum horizontal gun deflection (degrees)
						V_Min = 0.0, 			-- minimum vertical gun deflection (degrees)
						V_Max = 0.0,				-- maximum vertical gun deflection (degrees)
						H_Vel = 1.0,				-- horizontal gun rotation speed
						V_Vel = 1.0,
						SecondGun = 5,
						name = "Aft_turret2",							
					}
				),
		TurretMount ("LANC_AFT_L2", 				--5
					{
						gun = {
							supply = {
								shells = turret_ammo,
								mixes = {
									{3,3,3,3,2},
								},
								count = 2500,
							},
							max_burst_length = 300,
							rates = {1150}, -- unsynchronized mount
							recoil_coeff =  0.7*1.3,
							barrel_circular_error = 0.0002,
							barrels_count = 1,
							trigger = {name ="GunTrigger"},
							ejector_pos = {0.0, 0.0, -0.5},
							ejector_dir = {-1.0, 0.0, 0.0},
						},
						muzzle_pos_connector = "GUN_6",
						--effect_arg_number = 1004,
						count = 2500,
						azimuth_initial = 180,
						elevation_initial = 0.0,
						aft_gun_mount		  = false,
					} , 
					{	
						name = "Aft_turret2",							
						SlaveGun = true,
					}
				),			
			

		-- FORWARD TURRET FN5
		TurretMount ("LANC_FWD_1", --6 
						{
							gun = {
								supply = {
									shells = turret_ammo,
									mixes = {
										{3,3,3,2,4},
									},
									count = 1000,
								},
								max_burst_length = 300,
								rates = {1150}, -- unsynchronized mount
								recoil_coeff =  0.7*1.3,
								barrel_circular_error = 0.0002,
								barrels_count = 1,
								trigger = {name ="GunTrigger"},
								ejector_pos = {0.0, 0.0, -0.5},
								ejector_dir = {-1.0, 0.0, 0.0},
							},
							category = 8,
							muzzle_pos_connector = "GUN_1",
						--	effect_arg_number = 1004,
							azimuth_initial = 0.0,
							elevation_initial = 0.0,
							aft_gun_mount = false,
							-- effects = {
							-- 	{name = "FireEffect", arg = 432, attenuation = 2.0, light_pos = {0.5, 0.5, 0.0} , light_time = 0.1},
							-- 	{name = "SmokeEffect"},
							-- }

						} , 
						{	
							name = "Fwd_turret",
							H_Arg = 1011,				-- horizontal rotation argument
							V_Arg = 1012,				-- vertical rotation argument
							H_Min = -95.0,				-- minimum horizontal gun deflection (degrees)
							H_Max =  95.0,				-- maximum horizontal gun deflection (degrees)
							V_Min =  -45.0, 			-- minimum vertical gun deflection (degrees)
							V_Max =  60.0,				-- maximum vertical gun deflection (degrees)
							H_Vel =  90.0,				-- horizontal gun rotation speed
							V_Vel =  70.0,
							SecondGun = 6,
							crewMemberInCommandIdx	= 2, -- crew member controlling this turret 
						}
					),
		TurretMount ("LANC_FWD_2", 				--7
						{
							gun = {
								supply = {
									shells = turret_ammo,
									mixes = {
										{3,3,3,2,4},
									},
									count = 1000,
								},
								max_burst_length = 300,
								rates = {1150}, -- unsynchronized mount
								recoil_coeff =  0.7*1.3,
								barrel_circular_error = 0.0002,
								barrels_count = 1,
								trigger = {name ="GunTrigger"},
								ejector_pos = {0.0, 0.0, -0.5},
								ejector_dir = {-1.0, 0.0, 0.0},
							},
							category = 8,
							muzzle_pos_connector = "GUN_2",
						--	effect_arg_number = 1004,
							azimuth_initial = 0.0,
							elevation_initial = 0.0,
							aft_gun_mount = false,
						} , 
						{	
							name = "Fwd_turret",							
							SlaveGun = true,
						}
					),
					
	 },
	
	Pylons =     {
        pylon(1, 2, 5, -0.25, -0.5,  -- pylon #, type = (0 = rail launch, 1 = drop, 2 = internal bay), location x,y,z
            {
				connector = "Pylon1",
				use_full_connector_position=true,
				arg = 26 ,arg_value = 0.0  -- set this to 1.0 for bombay to be open by default and in mission editor
            },
            {
				{ CLSID = "{Lanc_1000MC}" }, -- 1000lb bomb
				{ CLSID = "{British_MC_500LB_Bomb_Mk2}" }, -- 500lb bomb
				{ CLSID = "{British_MC_250LB_Bomb_Mk2}" }, -- 250lb bomb
				{ CLSID = "{Lanc_Container}" }, -- Incendiary dispenser
			}),
		pylon(2, 2, 5, -0.25, 0,  -- pylon #, type = (10 = rail launch, 1 = drop, 2 = internal bay), location x,y,z
			{
				connector = "Pylon2",
				use_full_connector_position=true,
			--	arg = 26 ,arg_value = 0.0  -- set this to 1.0 for bombay to be open by default and in mission editor
			},
			{
				{ CLSID = "{Lanc_1000MC}" }, -- 1000lb bomb
				{ CLSID = "{British_MC_500LB_Bomb_Mk2}" }, -- 500lb bomb
				{ CLSID = "{British_MC_250LB_Bomb_Mk2}" }, -- 250lb bomb
				{ CLSID = "{Lanc_Container}" }, -- Incendiary dispenser

			}),
		pylon(3, 2, 5, -0.25, 0.5,  -- pylon #, type = (10 = rail launch, 1 = drop, 2 = internal bay), location x,y,z
			{
				connector = "Pylon3",
				use_full_connector_position=true,
			},
			{
				{ CLSID = "{Lanc_1000MC}" }, -- 1000lb bomb
				{ CLSID = "{British_MC_500LB_Bomb_Mk2}" }, -- 500lb bomb
				{ CLSID = "{British_MC_250LB_Bomb_Mk2}" }, -- 250lb bomb	
				{ CLSID = "{Lanc_Container}" }, -- Incendiary dispenser
			
			}),
		pylon(4, 2, 2.5, -0.25, -0.5,
            {
				connector = "Pylon4",
				use_full_connector_position=true,
            },
            {
				{ CLSID = "{Lanc_1000MC}" }, -- 1000lb bomb
				{ CLSID = "{British_MC_500LB_Bomb_Mk2}" }, -- 500lb bomb
				{ CLSID = "{British_MC_250LB_Bomb_Mk2}" }, -- 250lb bomb
				{ CLSID = "{Lanc_2000AP}" }, -- 2000lb AP bomb
				{ CLSID = "{Lanc_Container}" }, -- Incendiary dispenser

			}),
		pylon(5, 2, 2.5, -0.25, 0,
            {
				connector = "Pylon5",
				use_full_connector_position=true,
            },
            {
				{ CLSID = "{Lanc_1000MC}" }, -- 1000lb bomb
				{ CLSID = "{British_MC_500LB_Bomb_Mk2}" },  -- 500lb bomb
				{ CLSID = "{British_MC_250LB_Bomb_Mk2}" },  -- 250lb bomb
				{ CLSID = "{Lanc_2000AP}" }, -- 2000lb AP bomb
				{ CLSID = "{Lanc_Container}" }, -- Incendiary dispenser


            }),
		pylon(6, 2, 2.5, -0.25, 0.5,
            {
				connector = "Pylon6",
				use_full_connector_position=true,
            },
            {
				{ CLSID = "{Lanc_1000MC}" }, -- 1000lb bomb
				{ CLSID = "{British_MC_500LB_Bomb_Mk2}" }, -- 500lb bomb
				{ CLSID = "{British_MC_250LB_Bomb_Mk2}" }, -- 250lb bomb 
				{ CLSID = "{Lanc_2000AP}" }, -- 2000lb AP bomb
				{ CLSID = "{Lanc_Container}" }, -- Incendiary dispenser
           
			}),
		pylon(7, 2, 0, 0, 0,
            {
				connector = "Pylon7",
				use_full_connector_position=true,
            },
            {
				{ CLSID = "{Lanc_1000MC}" }, -- 1000lb bomb
				{ CLSID = "{British_MC_500LB_Bomb_Mk2}" }, -- 500lb bomb
				{ CLSID = "{British_MC_250LB_Bomb_Mk2}" }, -- 250lb bomb
				{ CLSID = "{Lanc_Container}" }, -- Incendiary dispenser

            }),
		pylon(8, 0, 0, 0, -4,
            {
				connector = "Pylon8",
				use_full_connector_position=true,
            },
            {
				{ CLSID = "{Lanc_Cookie}"}, -- 4000lb cookie
				{ CLSID = "{Lanc_Tallboy}"}, -- 12000lb Tall Boy
				{ CLSID = "{Lanc_Grandslam}"}, -- 22000lb monstrosity
				{ CLSID = "{UPKEEP}"}, 		 -- Lancaster's famous bouncing bomb
				{ CLSID = "{UPKEEP_INERT}"}, -- Lancaster's famous bouncing bomb, but inert

            }),
		pylon(9, 2, 0, 0, 0,
            {
				connector = "Pylon9",
				use_full_connector_position=true,
            },
            {
				{ CLSID = "{Lanc_1000MC}"}, -- 1000lb bomb
				{ CLSID = "{British_MC_500LB_Bomb_Mk2}"}, -- 500lb bomb
				{ CLSID = "{British_MC_250LB_Bomb_Mk2}"}, -- 250lb bomb
				{ CLSID = "{Lanc_Container}"}, -- Incendiary dispenser


            }),
		pylon(10, 2, -2.5, -0.25, -0.5,
            {
				connector = "Pylon10",
				use_full_connector_position=true,
            },
            {
				{ CLSID = "{Lanc_1000MC}"}, 	-- 1000lb bomb
				{ CLSID = "{British_MC_500LB_Bomb_Mk2}"}, 	-- 500lb bomb
				{ CLSID = "{British_MC_250LB_Bomb_Mk2}"}, 	-- 250lb bomb
				{ CLSID = "{Lanc_2000AP}"}, -- 2000lb AP bomb
				{ CLSID = "{Lanc_Container}"}, -- Incendiary dispenser
			}),
		pylon(11, 2, -2.5, -0.25, 0,
            {
				connector = "Pylon11",
				use_full_connector_position=true,
            },
            {
				{ CLSID = "{Lanc_1000MC}"}, -- 1000lb bomb
				{ CLSID = "{British_MC_500LB_Bomb_Mk2}"}, -- 500lb bomb
				{ CLSID = "{British_MC_250LB_Bomb_Mk2}"}, -- 250lb bomb
				{ CLSID = "{Lanc_2000AP}" }, -- 2000lb AP bomb
				{ CLSID = "{Lanc_Container}"}, -- Incendiary dispenser


			}),
		pylon(12, 2, -2.5, -0.25, 0.5,
            {
				connector = "Pylon12",
				use_full_connector_position=true,
            },
            {
				{ CLSID = "{Lanc_1000MC}" }, -- 1000lb bomb
				{ CLSID = "{British_MC_500LB_Bomb_Mk2}" }, -- 500lb bomb
				{ CLSID = "{British_MC_250LB_Bomb_Mk2}" }, -- 250lb bomb
				{ CLSID = "{Lanc_2000AP}" }, -- 2000lb AP bomb
				{ CLSID = "{Lanc_Container}"}, -- Incendiary dispenser

			}),
		pylon(13, 2, -4, -0.25, 0.5,
            {
				connector = "Pylon13",
				use_full_connector_position=true,
            },
            {
				--{ CLSID = "{Lanc_1000MC}" }, -- 1000lb bomb
				{ CLSID = "{British_MC_500LB_Bomb_Mk2}"}, -- 500lb bomb
				{ CLSID = "{British_MC_250LB_Bomb_Mk2}"}, -- 250lb bomb
				{ CLSID = "{Lanc_Container}"}, -- Incendiary dispenser

			}),
		pylon(14, 2, -4, -0.25, 0,
            {
				connector = "Pylon14",
				use_full_connector_position=true,
            },
            {
				--{ CLSID = "{Lanc_1000MC}" }, -- 1000lb bomb
				{ CLSID = "{British_MC_500LB_Bomb_Mk2}"}, -- 500lb bomb
				{ CLSID = "{British_MC_250LB_Bomb_Mk2}"}, -- 250lb bomb
				{ CLSID = "{Lanc_Container}"}, -- Incendiary dispenser

			}),
		pylon(15, 2, -4, -0.25, -0.5,
            {
				connector = "Pylon15",
				use_full_connector_position=true,
            },
            {
				--{ CLSID = "{Lanc_1000MC}" }, -- 1000lb bomb
				{ CLSID = "{British_MC_500LB_Bomb_Mk2}" }, -- 500lb bomb
				{ CLSID = "{British_MC_250LB_Bomb_Mk2}" }, -- 250lb bomb
				{ CLSID = "{Lanc_Container}" }, -- Incendiary dispenser

			}),
		pylon(16, 2, -6, -0.25, 0.3,
            {
				connector = "Pylon16",
				use_full_connector_position=true,
            },
            {
				{ CLSID = "{Lanc_FLARE}"}, -- Target Illumination Flare
			}),
    },
	
	Tasks = {
        aircraft_task(GroundAttack),
        aircraft_task(RunwayAttack),
        aircraft_task(PinpointStrike),
        aircraft_task(AntishipStrike),
		
		
    },	
	DefaultTask = aircraft_task(GroundAttack),
	

	SFM_Data = {
		-- known info
		-- airfoil NACA 23018
		-- from xfoil
		-- http://airfoiltools.com/airfoil/details?airfoil=naca23018-il#polars
		-- 0 Cl 60kt Cd 0.02
		
				aerodynamics = -- Cx = Cx_0 + Cy^2*B2 +Cy^4*B4
				{
					Cy0			=	0.55,   -- zero AoA lift coefficient 
					Mzalfa		=	3.2,--0.9,    -- 5.2,  	-- coefficients for pitch authority (M-oment around z per alpha)
					Mzalfadt	=	0.8,    -- coefficients for pitch response (Moment around z per alpha increase per dt)
					kjx			=	2.6,    -- Inertia parametre X - Dimension (clean) airframe drag coefficient at X (Top) Simply the wing area in square meters (as that is a major factor in drag calculations) - smaller = massive inertia
					kjz			=	0.00125,-- Inertia parametre Z - Dimension (clean) airframe drag coefficient at Z (Front) Simply the wing area in square meters (as that is a major factor in drag calculations)
					Czbe		=	-0.016, 	-- coefficient, along Z axis (perpendicular), affects yaw, negative value means force orientation in FC coordinate system
					cx_gear		=	0.04,   -- coefficient, drag, gear
					cx_flap		=	0.09,   -- coefficient, drag, full flaps
					cy_flap		=	0.36,   -- coefficient, normal force, lift, flaps
					cx_brk		=	0.01,   -- coefficient, drag, brakes
					table_data  = 
					{	--      M		Cx0		 	Cya			B		 B4	    	Omxmax		Aldop		Cymax
						[1] = 	{0,		0.022,		0.12,	0.06,		0.0001,		0.03,		15,			1.2},
						[2] = 	{0.05,	0.0224,		0.12,	0.06,		0.0001,		0.1,		13,			1.3},
						[3] = 	{0.1,	0.0224,		0.12,	0.06,		0.0001,		0.2,		17,			1.33},
						[4] = 	{0.15,	0.0224,		0.12,	0.06,		0.0001,		0.45,		17,			1.35},
						[5] = 	{0.2,	0.0224,		0.12,	0.06,		0.0001,		0.4,		15,			1.37},
						[6] = 	{0.25,	0.0224,		0.12,	0.06,		0.0001,		0.3,		15,			1.4},
						[7] = 	{0.3,	0.0224,		0.12,	0.06,		0.0001,		0.27,		15,			1.3},
						[8] = 	{0.35,	0.0224,		0.12,	0.06,		0.0001,		0.21,		15,			1.2},
						[9] = 	{0.4,	0.0224,		0.12,	0.06,		0.0001,		0.21,		14,			1.1},
						[10] = 	{0.45,	0.0224,		0.12,	0.06,		0.0001,		0.21,		13,			0.8},
						[11] = 	{0.5,	0.0224,		0.12,	0.06,		0.0001,		0.21,		12,			0.4},
						[12] = 	{1	,	0.0224,		0.12,	0.05,		0.0001,		0.14,		4,			0.2},
		
					}, -- end of table_data
					-- M - Mach number
					-- Cx0 - Coefficient, drag, profile, of the airplane
					-- Cya - Normal force coefficient of the wing and body of the aircraft in the normal direction to that of flight. Inversely proportional to the available G-loading at any Mach value. (lower the Cya value, higher G available) per 1 degree AOA
					-- B - Polar quad coeff
					-- B4 - Polar 4th power coeff
					-- Omxmax - roll rate, rad/s
					-- Aldop - Alfadop Max AOA at current M - departure threshold
					-- Cymax - Coefficient, lift, maximum possible (ignores other calculations if current Cy > Cymax)
				}, -- end of aerodynamics
		
		
		engine =          
		{
			Nmg					=	32, 
			Nominal_RPM 		=   3000.0,
			MinRUD				=	0,
			MaxRUD				=	1,
			MaksRUD				=	1,
			ForsRUD				=	1,
			type 				= "Piston",
			name				= "RollsRoyceMerlin",
			--[[
                E_TURBOJET = 0
                E_TURBOJET_AB = 1
                E_PISTON = 2
                E_TURBOPROP = 3
                E_TURBOFAN    = 4
                E_TURBOSHAFT = 5
            --]]			
			hMaxEng				=	12.5,  -- Max altitude for safe engine operation in km
			dcx_eng				=	0.015,  	-- Engine drag coeficient
            									-- Affects drag of engine when shutdown					 
			cemax				=	0.37,   -- cemax/cefor affect sponginess of elevator/inertia at slow speed
			cefor				=	0.37,   
			dpdh_m				=	1800,
			dpdh_f				=	1800,
			k_adiab_1			= 0.037923,
			k_adiab_2			= 0.0562,
			MAX_Manifold_P_1	= 155774,		
			MAX_Manifold_P_2	= 206570,		
			MAX_Manifold_P_3	= 226648,		
			k_after_cool		= 0.001 ,--0.54,
			Displ				= 27, 
			k_Eps				= 6,
			Stroke				= 0.152,
			V_pist_0			= 12,
			cylinder_firing_order = { 1, 12, 4, 9, 2, 11, 6, 7, 3, 10, 5, 8 },
			Nu_0				= 1.2,
			Nu_1				= 0.9,
			Nu_2				= 0.001,
			N_indic_0			= 1023040,
			N_fr_0				= 0.072,
			N_fr_1				= 0.02,
			Init_Mom			= 220,
			D_prop				= 4.0, 	-- meters, prop Diameter
			MOI_prop			= 80,  	-- moment of inertia of the prop
			k_gearbox			= 2.38, -- prop reduction gearbox ratio (##:1)
			P_oil				= 495438,
			k_boost				= 3,
			k_cfug				= 0.003,
			k_oil				= 0.00004,
			k_piston			= 3000,
			k_reg				= 0.003,
			k_vel				= 0.017,

			table_data = 
			{
			   --M			--Pmax
				{0.0,		17620.0},
				{0.1,		16600.0},
				{0.2,		15340.0},
				{0.3,		14320.0},
				{0.4,		13230.0},
				{0.5,		12300.0},
				{0.6,		11600.0},
				{0.7,		11050.0},
				{0.8,		10820.0},
				{0.9,		 6902.0},
				{1.9,		 3469.0}
			},

            Startup_Prework = 15.0,

			Startup_RPMs = {
                {0.0, 0},
                {2.0, 120},
                {5.6, 120},
                {5.5, 120},
                {6.5, 1100},
                {8.5, 900},
				{13.0, 900},
				{21.0, 550},
			},
            Startup_Ignition_Time = 6.0,
            Shutdown_Duration = 6,
			prop_pitch_min		= 23.0,	-- prop pitch min, degrees 
			prop_pitch_max		= 65.0,	-- prop pitch max, degrees 
			prop_pitch_feather	= 91.0,	-- prop pitch feather position, degrees if feather < prop_pitch_max no feathering available
            prop_blades_count   = 3,
            prop_locations      = {
				{4.9, 0.58, -7.68}, {0.0, 0.0, 0.0},  	-- engine 1
				{5.4, 0.29, -3.64}, {0.0, 0.0, 0.0},	-- engine 2
                {5.4, 0.29, 3.64}, {0.0, 0.0, 0.0}, 	-- forward/back,up/down,left/right
                {4.9, 0.58, 7.68}, {0.0, 0.0, 0.0},	   	-- engine 4

        	},
			extended = -- 
			{
				rpm_acceleration_time_factor = 
                {
                    RPM  = {0, 50, 100},
                    t    = {0.3,0.5,0.3}
                },
                rpm_deceleration_time_factor = 
                {
                    RPM  = {0, 50, 100},
                    t    = {0.3,0.5,0.5}
                },
			},
		}, -- end of engine
	},
	
	Failures = {},	

	lights_data = {
        typename = "collection",
        lights = {
			[1] = {
				-- landing lights
                typename = "collection",
			 	lights = { 
			 		{typename  = "argumentlight", connector = "LandingLight1",argument = 202, power_up_t = 2.8, movable = true, dir_correction = {elevation = math.rad(-1)}},	
			 		{typename  = "argumentlight", connector = "LandingLight2", argument = 203, power_up_t = 2.8, movable = true, dir_correction = {elevation = math.rad(-1)}}},	
			 	},
			[2] = {
				-- interior lighting as seen from the outside
				typename = "collection",
				lights = { 
					{typename  = "argumentlight", connector = "CabinLight_1",argument = 204, power_up_t = 2.8, dir_correction = {elevation = math.rad(-1)}}},
				},
			[3] = {
				-- navigation lights
				typename = "collection",
				lights = {
					{typename  = "argumentlight", connector = "NavLightL",argument = 256, power_up_t = 2.8, dir_correction = {elevation = math.rad(-1)}},	
					{typename  = "argumentlight", connector = "NavLightR", argument = 256, power_up_t = 2.8, dir_correction = {elevation = math.rad(-1)}}	}
				},

			[5] = {
					 -- Aldis aiming lights for Upkeep bouncing bomb
					typename = "collection",
					lights = { 
						{typename  = "spotlight", connector = "Upkeep_AimLight_Front",argument = 259, dir_correction = {elevation = math.rad(-1)}},	
						{typename  = "spotlight", connector = "Upkeep_AimLight_Rear", argument = 260, dir_correction = {elevation = math.rad(-1)}}	
					},
			},
            -- STROBES
		},
	},

	--[[ external model arguments to share in multiplayer (32 max) ]] --
	net_animation = {
        0,		--  1
		1,      -- 
		2, 		-- tail wheel 			2
        3, 		-- left gear			3
		4, 		-- left gear suspension
        5, 		-- right gear 			4
		6,      -- right gear suspension
        10, 	-- flaps				5
        11, 	-- right aileron		6
        12, 	-- left aileron			7
        16, 	-- elevators			8
        17, 	-- rudders				9
        26, 	-- bomb bay				10
		76, 	-- tial wheel rotation
		102, 	-- left wheel rotation	12
		103, 	-- right wheels rotation	13
		121,	-- Radiator flap 1
		122,	-- Radiator flap 2
		123,	-- Radiator flap 3
		124,	-- Radiator flap 4
		202,	-- landing light
		203,	-- landing light
		204,	-- cabin light
		250,	-- formation light red
		251,	-- formation light green
		252,	-- formation light amber
		256,	-- external power light
		370,		-- 14
		371,		-- 15
		372,		-- 16
		373,		-- 17
		407,  	-- engine 1 prop rotation	18
		408,	-- engine 2 prop rotation	19
		409,	-- engine 3 prop rotation	20
		410,	-- engine 4 prop rotation	21
		501,	-- engine 1 prop fade		22
		502,	-- engine 2 prop fade		23
		503,	-- engine 3 prop fade		24
		504,	-- engine 4 prop fade		25
		1005,	-- midupper turret rotation 	26	
		1006,   -- midupper turret elevation	27
		1011,	-- front turret			28 
		1012,	-- front turret			29
		1021,	-- tail turret			30
		1022,	-- tail turret			31
    },

	mechanimations = {
		BombBay = {{
				Sequence = { {
						C = { { "Arg", 26, "to", 1, "in", 12, "sign", 1 } }
					} },
				Transition = { "Close", "Open" }
			}, {
				Sequence = { {
						C = { { "Arg", 26, "to", 0, "in", 12, "sign", -1 } }
					} },
				Transition = { "Open", "Close" }
			}},
		LeftStrut = { {
				Flags = { "Reversible" },
				Sequence = { {
						C = { { "VelType", 3 }, { "Arg", 5, "from", 0, "to", 1, "in", 8 } }
					} },
				Transition = { "Retract", "Extend" }
			}, {
				Flags = { "Reversible" },
				Sequence = { {
						C = { { "VelType", 3 }, { "Arg", 5, "from", 1, "to", 0, "in", 10 } }
					} },
				Transition = { "Extend", "Retract" }
			}, {
				Sequence = { {
						C = { { "VelType", 3 }, { "PosType", 6 }, { "Arg", 5, "to", 0.5, "speed", 2, "sign", -1 } }
					} },
				Transition = { "Any", "Collapse" }
			} },
		RightStrut = { {
				Flags = { "Reversible" },
				Sequence = { {
						C = { { "VelType", 4 }, { "Arg", 3, "from", 0, "to", 1, "in", 8 } }
					} },
				Transition = { "Retract", "Extend" }
			}, {
				Flags = { "Reversible" },
				Sequence = { {
						C = { { "VelType", 4 }, { "Arg", 3, "from", 1, "to", 0, "in", 10 } }
					} },
				Transition = { "Extend", "Retract" }
			}, {
				Sequence = { {
						C = { { "VelType", 4 }, { "PosType", 7 }, { "Arg", 3, "to", 0.5, "speed", 2, "sign", -1 } }
					} },
				Transition = { "Any", "Collapse" }
			} },
		HeadLight0 = { {
				Sequence = { {
						C = { { "Arg", 257, "to", 0, "speed", 0.1, "sign", -1 } }
					} },
				Transition = { "Any", "Retract" }
			}, {
				Sequence = { {
						C = { { "Arg", 257, "to", 1, "speed", 0.1, "sign", 1 } }
					} },
				Transition = { "Any", "High" }
			} },
		

		Door0 = { {
				Flags = { "Reversible" },
				Sequence = { {
						C = { { "VelType", 3 }, { "Arg", 38, "to", 0.9, "in", 5 } }
					} },
				Transition = { "Close", "Open" }
			}, {
				Flags = { "Reversible", "StepsBackwards" },
				Sequence = { {
						C = { { "VelType", 3 }, { "Arg", 38, "to", 0, "in", 3 } }
					} },
				Transition = { "Open", "Close" }
			}, {
				Sequence = { {
						C = { { "Arg", 38, "set", 1 } }
					} },
				Transition = { "Any", "Bailout" }
			} },
		Door1 = { {
				Flags = { "Reversible" },
				Sequence = { {
						C = { { "VelType", 3 }, { "Arg", 109, "to", 0.9, "in", 5 } }
					} },
				Transition = { "Close", "Open" }
			}, {
				Flags = { "Reversible", "StepsBackwards" },
				Sequence = { {
						C = { { "VelType", 3 }, { "Arg", 109, "to", 0, "in", 3 } }
					} },
				Transition = { "Open", "Close" }
			}, {
				Sequence = { {
						C = { { "Arg", 109, "set", 1 } }
					} },
				Transition = { "Any", "Bailout" }
			} },
		},

	AddPropAircraft = {
	--	{id = "SoloFlight", control = 'checkbox' , label = _('Solo Flight'), defValue = false, weightWhenOn = -80},
		{id = "NetCrewControlPriority" , control = 'comboList', label = _('Aircraft Control Priority'), playerOnly = true,
		  values = {{id =  0, dispName = _("Pilot")},
					{id =  1, dispName = _("Instructor")},
					{id = -1, dispName = _("Ask Always")},
					{id = -2, dispName = _("Equally Responsible")}},
		  defValue  = 0,
		  wCtrl     = 150
		},
		{id = "H2S", control = 'checkbox' , label = _('H2S Ground Radar'), defValue = false, weightWhenOn = 120, arg = 600, wCtrl = 150}, -- TODO: find actual H2S installation weight
		{id = "Remove Bomb Bay Doors", control = 'checkbox' , label = _('Remove Bomb Bay Doors'), defValue = false, weightWhenOn = -800, arg = 601, wCtrl = 150}, 
		{id = "ExhaustShrouds", control = 'checkbox' , label = _('Engine Exhaust Shrouds'), defValue = false, weightWhenOn = 22, arg = 602, wCtrl = 150}, 
		{id = "Dambuster Low Altitude Aiming Lights", control = 'checkbox' , label = _('Dambuster Low Altitude Aiming Lights'), defValue = false, weightWhenOn = 0, arg = {259, 260}, wCtrl = 150}, -- 2 lamps at specific angles that produce circular reflections on the ground below, used by Dambuster flights to find correct altitude, in the dark, for the Upkeep drop.
		{id = "ResinLightYellow", control = 'checkbox', label = _('Yellow ResIn Light'), defValue = false, arg = 252, value = 0.15, wCtrl = 150},
		{id = "ResinLightGreen", control = 'checkbox', label = _('Green ResIn Light'), defValue = false, arg = 251, value = 0.15, wCtrl = 150},
		{id = "ResinLightRed", control = 'checkbox', label = _('Red ResIn Light'), defValue = false, arg = 250, value = 0.15, wCtrl = 150},

	},
}

add_aircraft(Lancaster_B1)
