dofile("Tools.lua")

dbgPrint("Loading Lancaster Engine Sounders")

offsets = {
	-- basic extern sounds
	extSpatial			= 0,
	extPropellorHums	= 0,
	extFrontalRoars		= 0,
	extBackwardRoars	= 0,
	extSideRoars		= 0,
	extUnstableIgnitionRoars = 0,

	-- exhaust sound detail
	extExhaustBlows		= 0,
	extExhaustPop		= 0,
	extExhaustDeafBlows	= 0,
	extExhaustCrackling	= 0,

	-- external startup and shutdown
	extStart			= 0,
	extShutdown			= 0,

	-- cockpit sounds
	intPropellorHums	= 0,
	intRoars			= 0,
	intUnstableIgnitionRoars = 0,
	intStart			= 0,
	intPropStart 		= 0,
	intShutdown			= 0,
	intExhaustPop		= 0,
	intExhaustCrackling = 0,

	-- damage sounds
	extMotorBroken		= 0,
	intMotorBroken		= 0,
	extMotorDry			= 0,
	intMotorBroken		= 0,
	extMotorStarterSpinUp = 0,
	intMotorStarterSpinUp = 0,
	extMotorStarterSpinDown = 0,
	intMotorStarterSpinDown = 0,
	extMotorStarterRedClutch = 0,
	intMotorStarterRedClutch = 0,

}

engine = {number = 0}

function engine:new()
	o = {}
	setmetatable(o, self)
	self.__index = self
	o.number = 1
	return o
end

function engine:init(number_, host)
	self:initNames()
	self:createSounds(number_, host)
end

function engine:initNames()
	

	dbgPrint("init names")

	-- path to sdef files in the [Mods\aircraft\Lancaster\Sounds\sdef\] folder
	-- external normal sounds
	self.extSpatial		    		= "Aircrafts/Engines/LancasterMerlin/EngSpatial"
	self.extSideRoars				= "Aircrafts/Engines/LancasterMerlin/Engine"
	self.extPropellorHums			= "Aircrafts/Engines/LancasterMerlin/extPropellorHums"
	self.extFrontalRoars			= "Aircrafts/Engines/LancasterMerlin/extFrontalRoars"
	self.extBackwardRoars			= "Aircrafts/Engines/LancasterMerlin/extBackwardRoars"
	self.extUnstableIgnitionRoars 	= "Aircrafts/Engines/LancasterMerlin/extUnstable"
	self.extStart					= "Aircrafts/Engines/LancasterMerlin/extStart"
	self.extPropStart				= "Aircrafts/Engines/LancasterMerlin/extPropStart"
	self.extShutdown				= "Aircrafts/Engines/LancasterMerlin/extShutdown"
	self.extExhaustBlows			= "Aircrafts/Engines/LancasterMerlin/extExhaust"
	self.extExhaustDeafBlows		= "Aircrafts/Engines/LancasterMerlin/extMisfire"
	self.extExhaustPop				= "Aircrafts/Engines/LancasterMerlin/extPop"
	self.extExhaustCrackling		= "Aircrafts/Engines/LancasterMerlin/extCrackle"

	-- cockpit normal sounds
	self.intPropellorHums			= "Aircrafts/Engines/LancasterMerlin/Cockpit/intPropellorHums"
	self.intRoars					= "Aircrafts/Engines/LancasterMerlin/Cockpit/intEngine"
	self.intUnstableIgnitionRoars	= "Aircrafts/Engines/LancasterMerlin/Cockpit/intUnstable"
	self.intStart					= "Aircrafts/Engines/LancasterMerlin/Cockpit/intStart"
	self.intShutdown				= "Aircrafts/Engines/LancasterMerlin/Cockpit/intShutdown"
	self.intExhaustPop				= "Aircrafts/Engines/LancasterMerlin/Cockpit/intPop"
	self.intExhaustCrackling 		= "Aircrafts/Engines/LancasterMerlin/Cockpit/intCrackle"

	self.extMotorBroken		= "Aircrafts/Engines/LancasterMerlin/extBroken"
	self.extMotorDry		= "Aircrafts/Engines/LancasterMerlin/extOuttaGas"
	self.intMotorBroken		= "Aircrafts/Engines/LancasterMerlin/intBroken"
	self.intMotorDry		= "Aircrafts/Engines/LancasterMerlin/intOuttaGas"

	self.extMotorStarterSpinUp	  = "Aircrafts/Engines/LancasterMerlin/SideEngine"
	self.extMotorStarterSpinDown  = "Aircrafts/Engines/LancasterMerlin/SideEngine"
	self.extMotorStarterRedClutch = "Aircrafts/Engines/LancasterMerlin/SideEngine"

	self.intMotorStarterSpinUp	  = "Aircrafts/Engines/LancasterMerlin/SideEngine"
	self.intMotorStarterSpinDown  = "Aircrafts/Engines/LancasterMerlin/SideEngine"
	self.intMotorStarterRedClutch = "Aircrafts/Engines/LancasterMerlin/SideEngine"

end

function engine:createSounds(number_, host)
	self.number = number_

	dbgPrint("init: " .. self.number)


	if self.extSpatial ~= nil then
		self.extSpatial= ED_AudioAPI.createSource(host, self.extSpatial)
	end
	
	if self.extPropellorHums ~= nil then
		self.extPropellorHums= ED_AudioAPI.createSource(host, self.extPropellorHums)
	end

	if self.extFrontalRoars ~= nil then
		self.extFrontalRoars = ED_AudioAPI.createSource(host, self.extFrontalRoars)
	end

	if self.extBackwardRoars ~= nil then
		self.extBackwardRoars = ED_AudioAPI.createSource(host, self.extBackwardRoars)
	end

	if self.extSideRoars ~= nil then
		self.extSideRoars = ED_AudioAPI.createSource(host, self.extSideRoars)
	end

	if self.extUnstableIgnitionRoars ~= nil then
		self.extUnstableIgnitionRoars = ED_AudioAPI.createSource(host, self.extUnstableIgnitionRoars)
	end

	if self.extPropStart ~= nil then
		self.extPropStart = ED_AudioAPI.createSource(host, self.extPropStart)
	end

	if self.extExhaustBlows ~= nil then
		self.extExhaustBlows = ED_AudioAPI.createSource(host, self.extExhaustBlows)
	end

	if self.extExhaustPop ~= nil then
		self.extExhaustPop = ED_AudioAPI.createSource(host, self.extExhaustPop)
	end

	if self.extExhaustCrackling ~= nil then
		self.extExhaustCrackling = ED_AudioAPI.createSource(host, self.extExhaustCrackling)
	end

	if self.extExhaustDeafBlows ~= nil then
		self.extExhaustDeafBlows = ED_AudioAPI.createSource(host, self.extExhaustDeafBlows)
	end

	if self.extShutdown ~= nil then
		self.extShutdown = ED_AudioAPI.createSource(host, self.extShutdown)
	end

	if self.extPropStart ~= nil then
		self.extPropStart = ED_AudioAPI.createSource(host, self.extPropStart)
	end

end

function engine:initCptNames()
	
	
	self.engine_l_name  = "Aircrafts/Engines/LancasterMerlin/Cockpit/intEngine" -- path to sdef files in the [Mods\aircraft\Lancaster\Sounds\Effects\Aircrafts\Engines\Lancaster] folder
	self.engine_r_name  = "Aircrafts/Engines/LancasterMerlin/Cockpit/intEngine"
	self.heAmb_l_name   = "Aircrafts/Engines/LancasterMerlin/engSpatial"
	self.heAmb_r_name   = "Aircrafts/Engines/LancasterMerlin/engSpatial"
	
	-- self.engine_l_name  = "Aircrafts/Engines/InEngineL" -- path to sdef files in the [Mods\aircraft\Lancaster\Sounds\Effects\Aircrafts\Engines\Lancaster] folder
	-- self.engine_r_name  = "Aircrafts/Engines/InEngineR"
	-- self.heAmb_l_name   = "Aircrafts/Engines/InHeAmbL"
	-- self.heAmb_r_name   = "Aircrafts/Engines/InHeAmbR"
end

function engine:createSoundsCpt(hostCpt)
	 if self.number == 1 then
	 	if self.engine_l_name ~= nil then
	 		self.sndCpt = ED_AudioAPI.createSource(hostCpt, self.engine_l_name)
	 	end
		
	 	if self.engine_l2_name ~= nil then
	 		self.sndCpt2 = ED_AudioAPI.createSource(hostCpt, self.engine_l2_name)
	 	end
		
	 	if self.heAmb_l_name ~= nil then
	 		self.sndCptAmb = ED_AudioAPI.createSource(hostCpt, self.heAmb_l_name)
	 	end

	elseif self.number == 2 then
	 	if self.engine_r_name ~= nil then
	 		self.sndCpt = ED_AudioAPI.createSource(hostCpt, self.engine_r_name)
	 	end
		
	 	if self.engine_r2_name ~= nil then
	 		self.sndCpt2 = ED_AudioAPI.createSource(hostCpt, self.engine_r2_name)
	 	end
		
	 	if self.heAmb_r_name ~= nil then
	 		self.sndCptAmb = ED_AudioAPI.createSource(hostCpt, self.heAmb_r_name)
	 	end
	 end
end

function engine:destroySoundsCpt()
	if self.sndCpt ~= nil then
		ED_AudioAPI.destroySource(self.sndCpt)
		self.sndCpt = nil
	end
	
	if self.sndCpt2 ~= nil then
		ED_AudioAPI.destroySource(self.sndCpt2)
		self.sndCpt2 = nil
	end
	
	if self.sndCptAmb ~= nil then
		ED_AudioAPI.destroySource(self.sndCptAmb)
		self.sndCptAmb = nil
	end
end

function engine:calculatePitchGainCore(coreRPM)
	return coreRPM, math.sqrt(coreRPM)
end

function engine:calculatePitchGainCore2(coreRPM, fanRPM)
	return coreRPM, math.sqrt(coreRPM)
end

function engine:calculatePitchGainCore3(coreRPM, fanRPM)
	return coreRPM, math.sqrt(coreRPM)
end

function engine:calculatePitchGainFan(fanRPM)
	local gain = 1
	if fanRPM < 0.5 then
		gain = fanRPM * 2
	end
	
	return fanRPM, gain
end

function engine:calculatePitchGainTurb(fanRPM, coreRPM, turbPower)
	local pitch = fanRPM
	if pitch == 0 then
		pitch = coreRPM -- using core if no fan is present
	end
	return pitch, turbPower
end

function engine:calculatePitchGainAround(fanRPM, coreRPM, coreRPM2)
	local pitch = fanRPM
	if pitch == 0 then
		pitch = coreRPM -- using core if no fan is present
	end
	
	return pitch, math.max(0, 5.6592*coreRPM2*coreRPM2 - 13.259*coreRPM2*coreRPM + 8.3924*coreRPM2 - 0.337*coreRPM - 0.0048)
end

function engine:calculatePitchGainJet(fanRPM, coreRPM, thrust, flame)
	local RPM = fanRPM
	if RPM == 0 then
		RPM = coreRPM -- using core if no fan is present
	end
	
	local gain = math.sqrt(thrust)
	if thrust < 0.05 and flame > 0 then
		gain = 0.23 * coreRPM / 0.7
	end
		
	return 0.5 + 0.5 * RPM, gain
end

function engine:calculatePitchGainJet2(thrust)
	local gain
	if thrust > 0.4 then
		gain =  1.67 * thrust - 0.67
	else
		gain = 0
	end
		
	return 1.0, gain
end

function engine:calculatePitchGainCpt(coreRPM)
	return coreRPM, 0.4 * math.sqrt(coreRPM)
end

function engine:calculatePitchGainCpt2(coreRPM, fanRPM, turbPower, vTrue)
	return coreRPM, 1 - (math.exp(-(math.pow(coreRPM, 7))))
end
--
function engine:calculatePitchGainCptAmb(coreRPM, coreRPM2)
	local gain = 1
	if coreRPM < 0.6784 then
		gain = math.max(0, 2.0967 * coreRPM2 + 0.0516 * coreRPM - 6E-15)
	end
	
	return 1, gain
end

function engine:DBGstop()
	stopSRC = function(src)
		if src ~= nil then
			if ED_AudioAPI.isSourcePlaying(src) then
				dbgPrint("src: " .. src)
				ED_AudioAPI.stopSource(src)
			end
		end
	end
	
	stopSRC(self.sndCore)
	stopSRC(self.sndCore2)
	stopSRC(self.sndCore3)
	stopSRC(self.sndJet)
	stopSRC(self.sndJet2)
	stopSRC(self.sndAround)
	stopSRC(self.sndAround2)
	stopSRC(self.sndFan)
	stopSRC(self.sndTurb)
		
	stopSRC(self.sndCpt)
	stopSRC(self.sndCpt2)
	stopSRC(self.sndCptAmb)
end

function engine:controlSound(snd, pitch, gain, offsetKey)
	if gain < 0.01 then
		ED_AudioAPI.stopSource(snd)
	elseif gain >= 0.01 then
		dbgPrint("pitch: " .. pitch)
		dbgPrint("gain: " .. gain)
	
		ED_AudioAPI.setSourcePitch(snd, pitch)
		ED_AudioAPI.setSourceGain(snd, gain)
		
		if not ED_AudioAPI.isSourcePlaying(snd) then
			if offsetKey ~= nil then
				if offsets[offsetKey] ~= nil then
					ED_AudioAPI.playSourceLooped(snd, offsets[offsetKey])
					offsets[offsetKey] = offsets[offsetKey] + 0.5
				end
			else
				ED_AudioAPI.playSourceLooped(snd)
			end
		end
	end
end

function engine:update(coreRPM, fanRPM, turbPower, thrust, flame, vTrue)
	dbgPrint("engine:update")

	local corePitch, coreGain = self:calculatePitchGainCore(coreRPM)
	
	local coreRPM2 = coreRPM * coreRPM
	local aroundPitch, aroundGain = self:calculatePitchGainAround(fanRPM, coreRPM, coreRPM2)
	
	if self.sndCore ~= nil then
		dbgPrint("core")
		self:controlSound(self.extSpatial, corePitch, coreGain, "core")
	end
	
	if self.sndCore2 ~= nil then
		dbgPrint("core2")
		local core2Pitch, core2Gain = self:calculatePitchGainCore2(coreRPM, fanRPM)
		
		self:controlSound(self.extPropellorHums, core2Pitch, core2Gain, "core2")
	end
	
	-- if self.sndCore3 ~= nil then
	-- 	dbgPrint("core3")
	-- 	local core3Pitch, core3Gain = self:calculatePitchGainCore3(coreRPM, fanRPM)
		
	-- 	self:controlSound(self.ext, core3Pitch, core3Gain, "core3")
	-- end

	-- if self.sndFan ~= nil then
	-- 	dbgPrint("fan")
	-- 	local fanPitch, fanGain = self:calculatePitchGainFan(fanRPM)
	-- 	self:controlSound(self.sndFan, fanPitch, fanGain, "fan")
	-- end
	
	-- if self.sndAround ~= nil then
	-- 	dbgPrint("around")
	-- 	self:controlSound(self.sndAround, aroundPitch, aroundGain, "around")
	-- end
	
	-- if self.sndAround2 ~= nil then
	-- 	dbgPrint("around2")
	-- 	self:controlSound(self.sndAround2, aroundPitch, aroundGain, "around")
	-- end
	
	-- if self.sndTurb ~= nil then
	-- 	dbgPrint("turb")
	-- 	local turbPitch, turbGain = self:calculatePitchGainTurb(fanRPM, coreRPM, turbPower)
	-- 	self:controlSound(self.sndTurb, turbPitch, turbGain, "turb")
	-- end
	
	-- if self.sndJet ~= nil then
	-- 	dbgPrint("jet")
	-- 	local jetPitch, jetGain = self:calculatePitchGainJet(fanRPM, coreRPM, thrust, flame)
	-- 	self:controlSound(self.sndJet, jetPitch, jetGain, "jet")
	-- end
	
	-- if self.sndJet2 ~= nil then
	-- 	dbgPrint("jet2")
	-- 	local jet2Pitch, jet2Gain = self:calculatePitchGainJet2(thrust)
	-- 	self:controlSound(self.sndJet2, jet2Pitch, jet2Gain, "jet2")
	-- end
	
	-- if self.sndCpt ~= nil then
	-- 	local cptPitch, cptGain = self:calculatePitchGainCpt(coreRPM)
	-- 	self:controlSound(self.sndCpt, cptPitch, cptGain)
	-- end

	-- if self.sndCpt2 ~= nil then
	-- 	local cpt2Pitch, cpt2Gain = self:calculatePitchGainCpt2(coreRPM, fanRPM, turbPower, vTrue)
	-- 	self:controlSound(self.sndCpt2, cpt2Pitch, cpt2Gain)
	-- end
	
	-- if self.sndCptAmb ~= nil then
	-- 	local cptAmbPitch, cptAmbGain = self:calculatePitchGainCptAmb(coreRPM, coreRPM2)
	-- 	self:controlSound(self.sndCptAmb, cptAmbPitch, cptAmbGain)
	-- end
end



-- Effects/Aircrafts/Engines/RollsRoyceMerlin/Engine
-- Aircrafts/Engines/RollsRoyceMerlin/EngSpatial.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/PackardMerlinProp/EngSpatial
-- Aircrafts/Engines/RollsRoyceMerlin/ExB.sdef
-- Aircrafts/Engines/RollsRoyceMerlin/ExB1.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin/ExB1
-- Aircrafts/Engines/RollsRoyceMerlin/ExB2.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin/ExB2
-- Aircrafts/Engines/RollsRoyceMerlin/ExB3.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin/ExB3
-- Aircrafts/Engines/RollsRoyceMerlin/ExB4.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin/ExB4
-- Aircrafts/Engines/RollsRoyceMerlin/ExF.sdef
-- Aircrafts/Engines/RollsRoyceMerlin/ExF1.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin/ExF1
-- Aircrafts/Engines/RollsRoyceMerlin/ExF2.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin/ExF2
-- Aircrafts/Engines/RollsRoyceMerlin/ExF3.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin/ExF3
-- Aircrafts/Engines/RollsRoyceMerlin/ExF4.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin/ExF4
-- Aircrafts/Engines/RollsRoyceMerlin/ExhaustStart.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin/ExhaustStart
-- Aircrafts/Engines/RollsRoyceMerlin/ExR.sdef
-- Aircrafts/Engines/RollsRoyceMerlin/ExR1.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin/ExR1
-- Aircrafts/Engines/RollsRoyceMerlin/ExR2.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin/ExR2
-- Aircrafts/Engines/RollsRoyceMerlin/ExR3.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin/ExR3
-- Aircrafts/Engines/RollsRoyceMerlin/ExR4.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin/ExR4
-- Aircrafts/Engines/RollsRoyceMerlin/ExS.sdef
-- Aircrafts/Engines/RollsRoyceMerlin/ExS1.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin/ExS1
-- Aircrafts/Engines/RollsRoyceMerlin/ExS2.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin/ExS2
-- Aircrafts/Engines/RollsRoyceMerlin/ExS3.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin/ExS3
-- Aircrafts/Engines/RollsRoyceMerlin/ExS4.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin/ExS4
-- Aircrafts/Engines/RollsRoyceMerlin/Prop.sdef
-- Aircrafts/Engines/RollsRoyceMerlin/Prop1.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin/Prop1
-- Aircrafts/Engines/RollsRoyceMerlin/Prop2.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin/Prop2
-- Aircrafts/Engines/RollsRoyceMerlin/Prop3Back.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin/Prop3
-- Aircrafts/Engines/RollsRoyceMerlin/Prop3Front.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin/Prop3
-- Aircrafts/Engines/RollsRoyceMerlin/Prop3Side.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin/Prop3Side
-- Aircrafts/Engines/RollsRoyceMerlin/Prop4Back.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin/Prop4
-- Aircrafts/Engines/RollsRoyceMerlin/Prop4Front.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin/Prop4
-- Aircrafts/Engines/RollsRoyceMerlin/Prop4Side.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin/Prop4Side
-- Aircrafts/Engines/RollsRoyceMerlin/Shutdown.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin/Shutdown
-- Aircrafts/Engines/RollsRoyceMerlin/StartBot.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin/StartBot
-- Aircrafts/Engines/RollsRoyceMerlin/Starter.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin/Starter
-- Aircrafts/Engines/RollsRoyceMerlin/StarterStart.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin/StarterStart
-- Aircrafts/Engines/RollsRoyceMerlin25/EngSpatial.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/PackardMerlinProp/EngSpatial
-- Aircrafts/Engines/RollsRoyceMerlin25/ExB.sdef
-- Aircrafts/Engines/RollsRoyceMerlin25/ExB1.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin25/ExB1
-- Aircrafts/Engines/RollsRoyceMerlin25/ExB2.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin25/ExB2
-- Aircrafts/Engines/RollsRoyceMerlin25/ExB3.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin25/ExB3
-- Aircrafts/Engines/RollsRoyceMerlin25/ExB4.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin25/ExB4
-- Aircrafts/Engines/RollsRoyceMerlin25/ExB5.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin25/ExB5
-- Aircrafts/Engines/RollsRoyceMerlin25/ExF.sdef
-- Aircrafts/Engines/RollsRoyceMerlin25/ExF1.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin25/ExF1
-- Aircrafts/Engines/RollsRoyceMerlin25/ExF2.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin25/ExF2
-- Aircrafts/Engines/RollsRoyceMerlin25/ExF3.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin25/ExF3
-- Aircrafts/Engines/RollsRoyceMerlin25/ExF4.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin25/ExF4
-- Aircrafts/Engines/RollsRoyceMerlin25/ExF5.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin25/ExF5
-- Aircrafts/Engines/RollsRoyceMerlin25/ExR.sdef
-- Aircrafts/Engines/RollsRoyceMerlin25/ExR1.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin25/ExR1
-- Aircrafts/Engines/RollsRoyceMerlin25/ExR2.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin25/ExR2
-- Aircrafts/Engines/RollsRoyceMerlin25/ExR3.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin25/ExR3
-- Aircrafts/Engines/RollsRoyceMerlin25/ExR4.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin25/ExR4
-- Aircrafts/Engines/RollsRoyceMerlin25/ExR5.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin25/ExR5
-- Aircrafts/Engines/RollsRoyceMerlin25/ExS.sdef
-- Aircrafts/Engines/RollsRoyceMerlin25/ExS1_L.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin25/ExS1
-- Aircrafts/Engines/RollsRoyceMerlin25/ExS1_R.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin25/ExS1
-- Aircrafts/Engines/RollsRoyceMerlin25/ExS2_L.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin25/ExS2
-- Aircrafts/Engines/RollsRoyceMerlin25/ExS2_R.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin25/ExS2
-- Aircrafts/Engines/RollsRoyceMerlin25/ExS3_L.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin25/ExS3
-- Aircrafts/Engines/RollsRoyceMerlin25/ExS3_R.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin25/ExS3
-- Aircrafts/Engines/RollsRoyceMerlin25/ExS4.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin25/ExS4
-- Aircrafts/Engines/RollsRoyceMerlin25/ExS5.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin25/ExS5
-- Aircrafts/Engines/RollsRoyceMerlin25/ExSm.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/PackardMerlinProp/ExSmPop1
-- 		Effects/Aircrafts/Engines/PackardMerlinProp/ExSmPop2
-- 		Effects/Aircrafts/Engines/PackardMerlinProp/ExSmPop3
-- 		Effects/Aircrafts/Engines/PackardMerlinProp/ExSmPop4
-- Aircrafts/Engines/RollsRoyceMerlin25/MotorDry.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/PackardMerlinProp/MotorDry
-- Aircrafts/Engines/RollsRoyceMerlin25/Prop.sdef
-- Aircrafts/Engines/RollsRoyceMerlin25/Prop1.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin25/Prop1
-- Aircrafts/Engines/RollsRoyceMerlin25/Prop2.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin25/Prop2
-- Aircrafts/Engines/RollsRoyceMerlin25/Prop3.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin25/Prop3
-- Aircrafts/Engines/RollsRoyceMerlin25/Prop4Back.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin25/Prop4
-- Aircrafts/Engines/RollsRoyceMerlin25/Prop4Front.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin25/Prop4
-- Aircrafts/Engines/RollsRoyceMerlin25/Prop4Side_L.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin25/Prop4Side
-- Aircrafts/Engines/RollsRoyceMerlin25/Prop4Side_R.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin25/Prop4Side
-- Aircrafts/Engines/RollsRoyceMerlin25/Prop5Back.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin25/Prop5Back
-- Aircrafts/Engines/RollsRoyceMerlin25/Prop5Front.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin25/Prop5Front
-- Aircrafts/Engines/RollsRoyceMerlin25/Prop5Side_L.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin25/Prop5Side
-- Aircrafts/Engines/RollsRoyceMerlin25/Prop5Side_R.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin25/Prop5Side
-- Aircrafts/Engines/RollsRoyceMerlin25/Shutdown.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin25/Shutdown
-- Aircrafts/Engines/RollsRoyceMerlin25/StartBot.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin25/StartBot
-- Aircrafts/Engines/RollsRoyceMerlin25/Starter.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin25/Starter
-- Aircrafts/Engines/RollsRoyceMerlin25/StarterClutch.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin25/StarterClutch
-- Aircrafts/Engines/RollsRoyceMerlin25/StarterStart.sdef
-- 	wave:
-- 		Effects/Aircrafts/Engines/RollsRoyceMerlin25/StarterStart
