ViewSettings = {
	Cockpit = {
	[1] = {-- pilot
		CockpitLocalPoint      = {5.5878, 1.72, -0.273} ,	--cockpit model line up with external model {forward/back,up/down,left/right}  up {5.46, 1.669, 0.265}
		CameraViewAngleLimits  = {20,140}, -- FOV Min Max (how much zoom in/out)
		CameraAngleRestriction = {false,90,0.5},
		CameraAngleLimits      = {200,-90,110}, -- View right/left, View down/up
		limits_6DOF            = {x = {-12,10},y = {-10,10},z = {-10,10},roll = 90.0}, -- movement back/front bottom/top right/left
		EyePoint               = {0.1,0.1,0},	-- Distance from pivot point. To simulate pivot around human neck, use {0.16,0.1,0}
		ShoulderSize 		   = 0.15,	
		Allow360rotation	   = true,		
		},
	[2] = {-- bombardier
		CockpitLocalPoint      = {8.0, 0.15, 0.02} ,	--cockpit model line up with external model {forward/back,up/down,left/right}
		CameraViewAngleLimits  = {20,140}, -- FOV Min Max (how much zoom in/out)
		CameraAngleRestriction = {false,90,0.5},
		CameraAngleLimits      = {200,-90,110}, -- View right/left, View down/up
		limits_6DOF            = {x = {-10,10},y = {-10,10},z = {-10,10},roll = 90.0}, -- movement back/front bottom/top right/left
		EyePoint               = {0.1,0.1,0},	-- Distance from pivot point. To simulate pivot around human neck, use {0.16,0.1,0}
		ShoulderSize 		   = 0.01,	
		Allow360rotation	   = false,
		},
	[3] = {-- Engineer
		CockpitLocalPoint      = {4.85, 0.75, 0.2} ,	--cockpit model line up with external model {forward/back,up/down,left/right}
		CameraViewAngleLimits  = {20,140}, -- FOV Min Max (how much zoom in/out)
		CameraAngleRestriction = {false,90,0.5},
		CameraAngleLimits      = {200,-90,110}, -- View right/left, View down/up
		limits_6DOF            = {x = {-10,10},y = {-10,10},z = {-10,10},roll = 90.0}, -- movement back/front bottom/top right/left
		EyePoint               = {0.1,0.1,0},	-- Distance from pivot point. To simulate pivot around human neck, use {0.16,0.1,0}
		ShoulderSize 		   = 0.15,	
		Allow360rotation	   = true,		
		},
	[4] = {-- Navigator
		CockpitLocalPoint      = {4.3, 1.15, 0.5} ,	--cockpit model line up with external model {forward/back,up/down,left/right}
		CameraViewAngleLimits  = {20,140}, -- FOV Min Max (how much zoom in/out)
		CameraAngleRestriction = {false,90,0.5},
		CameraAngleLimits      = {200,-90,110}, -- View right/left, View down/up
		limits_6DOF            = {x = {-10,10},y = {-10,10},z = {-10,10},roll = 90.0}, -- movement back/front bottom/top right/left
		EyePoint               = {0.1,0.1,0},	-- Distance from pivot point. To simulate pivot around human neck, use {0.16,0.1,0}
		ShoulderSize 		   = 0.15,	
		Allow360rotation	   = true,		
		},
	[5] = {-- Wireless
		CockpitLocalPoint      = {2.2, 1.0, 0.5} ,	--cockpit model line up with external model {forward/back,up/down,left/right}
		CameraViewAngleLimits  = {20,140}, -- FOV Min Max (how much zoom in/out)
		CameraAngleRestriction = {false,90,0.2},
		CameraAngleLimits      = {200,-90,110}, -- View right/left, View down/up
		limits_6DOF            = {x = {-10,10},y = {-10,10},z = {-10,10},roll = 90.0}, -- movement back/front bottom/top right/left
		EyePoint               = {0.1,0.1,0},	-- Distance from pivot point. To simulate pivot around human neck, use {0.16,0.1,0}
		ShoulderSize 		   = 0.15,	
		Allow360rotation	   = true,		
		},
	[6] = {-- Mid Upper Gunner
		CockpitLocalPoint      = {-5.2, 2.2, 0.0} ,	--cockpit model line up with external model {forward/back,up/down,left/right}
		CameraViewAngleLimits  = {20,140}, -- FOV Min Max (how much zoom in/out)
		CameraAngleRestriction = {false,90,0.5},
		CameraAngleLimits      = {200,-90,110}, -- View right/left, View down/up
		limits_6DOF            = {x = {-10,10},y = {-10,10},z = {-10,10},roll = 90.0}, -- movement back/front bottom/top right/left
		EyePoint               = {0.1,0.1,0},	-- Distance from pivot point. To simulate pivot around human neck, use {0.16,0.1,0}
		ShoulderSize 		   = 0,	
		Allow360rotation	   = true,		
		},
	[7] = {-- tail gunner
		CockpitLocalPoint      = {-12.1, 1, 0.0} ,--{-12.1, 1, 0.0} ,	--cockpit model line up with external model {forward/back,up/down,left/right}
		CameraViewAngleLimits  = {20,140}, -- FOV Min Max (how much zoom in/out)
		CameraAngleRestriction = {false,90,0.5},
		CameraAngleLimits      = {200,-90,110}, -- View right/left, View down/up
		limits_6DOF            = {x = {-10,10},y = {-10,10},z = {-10,10},roll = 90.0}, -- movement back/front bottom/top right/left
		EyePoint               = {0.1,0.1,0},	-- Distance from pivot point. To simulate pivot around human neck, use {0.16,0.1,0}
		ShoulderSize 		   = 0,	
		Allow360rotation	   = true,		
		},
	}, -- Cockpit
		Chase = {	-- F4 view
			LocalPoint      = {-15,    0.86,    0},  -- back/front bottom/top right/left
			AnglesDefault   = {0.0,-15.0},
		}, -- Chase
		Arcade = {
			LocalPoint      = {-20.0,5.0,0.0},
			AnglesDefault   = {0.000000,-8.000000},
		}, -- Arcade
	}


local function pilot_head_pos(tab)	-- adjusts pilot view from origin of cockpit model
    if not tab then
	   tab = {}
	end
	tab.viewAngle = tab.viewAngle  or 75 -- initial FOV
	tab.hAngle    = tab.hAngle     or  0
	tab.vAngle    = tab.vAngle     or -9 -- angles down pilot view
	tab.x_trans   = tab.x_trans    or  0.0  -- moves pilot view forward from x=0 (cockpit model)
	tab.y_trans   = tab.y_trans    or  0.11  -- moves view up
	tab.z_trans   = tab.z_trans    or  0  -- moves view right
	tab.rollAngle = tab.rollAngle  or  0
	return tab
end

SnapViews = {
[1] = {-- player slot 1
	[1] = pilot_head_pos({}),	-- num 0
	[2] = pilot_head_pos({}),	--LWin + Num1 : Snap View 1
	[3] = pilot_head_pos({}),
	[4] = pilot_head_pos({}),
	[5] = pilot_head_pos({}),
	[6] = pilot_head_pos({}),
	[7] = pilot_head_pos({}),
	[8] = pilot_head_pos({}),
	[9] = pilot_head_pos({}),
	[10] = pilot_head_pos({}),
	[13] = pilot_head_pos({}),	-- default view
    [14] = pilot_head_pos({}),	-- vr view
	},
[2] = {-- player slot 2
	[1] = pilot_head_pos({}),	-- num 0
	[2] = pilot_head_pos({}),	--LWin + Num1 : Snap View 1
	[3] = pilot_head_pos({}),
	[4] = pilot_head_pos({}),
	[5] = pilot_head_pos({}),
	[6] = pilot_head_pos({}),
	[7] = pilot_head_pos({}),
	[8] = pilot_head_pos({}),
	[9] = pilot_head_pos({}),
	[10] = pilot_head_pos({}),
	[13] = pilot_head_pos({}),	-- default view	
	[14] = pilot_head_pos({}),	-- default view	
	},
	
[3] = {-- player slot 2
	[1] = pilot_head_pos({}),	-- num 0
	[2] = pilot_head_pos({}),	--LWin + Num1 : Snap View 1
	[3] = pilot_head_pos({}),
	[4] = pilot_head_pos({}),
	[5] = pilot_head_pos({}),
	[6] = pilot_head_pos({}),
	[7] = pilot_head_pos({}),
	[8] = pilot_head_pos({}),
	[9] = pilot_head_pos({}),
	[10] = pilot_head_pos({}),
	[13] = pilot_head_pos({hAngle = -90}),	-- default view	
	[14] = pilot_head_pos({hAngle = -90}),	-- default view	
	},
	
[4] = {-- player slot 2
	[1] = pilot_head_pos({}),	-- num 0
	[2] = pilot_head_pos({}),	--LWin + Num1 : Snap View 1
	[3] = pilot_head_pos({}),
	[4] = pilot_head_pos({}),
	[5] = pilot_head_pos({}),
	[6] = pilot_head_pos({}),
	[7] = pilot_head_pos({}),
	[8] = pilot_head_pos({}),
	[9] = pilot_head_pos({}),
	[10] = pilot_head_pos({}),
	[13] = pilot_head_pos({hAngle = 90,vAngle     = -30,}),	-- default view	
	[14] = pilot_head_pos({hAngle = 90,vAngle     = -30,}),	-- default view	
	},
	
[5] = {-- player slot 2
	[1] = pilot_head_pos({}),	-- num 0
	[2] = pilot_head_pos({}),	--LWin + Num1 : Snap View 1
	[3] = pilot_head_pos({}),
	[4] = pilot_head_pos({}),
	[5] = pilot_head_pos({}),
	[6] = pilot_head_pos({}),
	[7] = pilot_head_pos({}),
	[8] = pilot_head_pos({}),
	[9] = pilot_head_pos({}),
	[10] = pilot_head_pos({}),
	[13] = pilot_head_pos({}),	-- default view	
	[14] = pilot_head_pos({}),	-- default view	
	},
	
[6] = {-- player slot 2
	[1] = pilot_head_pos({}),	-- num 0
	[2] = pilot_head_pos({}),	--LWin + Num1 : Snap View 1
	[3] = pilot_head_pos({}),
	[4] = pilot_head_pos({}),
	[5] = pilot_head_pos({}),
	[6] = pilot_head_pos({}),
	[7] = pilot_head_pos({}),
	[8] = pilot_head_pos({}),
	[9] = pilot_head_pos({}),
	[10] = pilot_head_pos({}),
	[13] = pilot_head_pos({hAngle = 180}),	-- default view	
	[14] = pilot_head_pos({hAngle = 180}),	-- default view	
	},
	
[7] = {-- player slot 2
	[1] = pilot_head_pos({}),	-- num 0
	[2] = pilot_head_pos({}),	--LWin + Num1 : Snap View 1
	[3] = pilot_head_pos({}),
	[4] = pilot_head_pos({}),
	[5] = pilot_head_pos({}),
	[6] = pilot_head_pos({}),
	[7] = pilot_head_pos({}),
	[8] = pilot_head_pos({}),
	[9] = pilot_head_pos({}),
	[10] = pilot_head_pos({}),
	[13] = pilot_head_pos({hAngle = 180}),	-- default view	
	[14] = pilot_head_pos({hAngle = 180}),	-- default view	
	},
}
